/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.Chaine;
import cds.aladin.Plan;
import cds.aladin.PlanBG;
import cds.aladin.PlanBGRgb;
import cds.aladin.prop.PropPanel;
import cds.allsky.Action;
import cds.allsky.BuilderRgb;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.MainPanel;
import cds.allsky.ModeTree;
import cds.allsky.Param;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabRgb
extends JPanel
implements ActionListener {
    private static int TEXTSIZE = 6;
    private static final String[] RGB = new String[]{"Red", "Green", "Blue"};
    private static String B;
    private static String G;
    private static String R;
    private String REP_DEST;
    private String RGBALLSKY;
    private String BROWSE;
    private String HELP;
    private String CHOOSE = "-- select a plane --";
    private JLabel dirLabel = new JLabel();
    private JButton browse = new JButton();
    private JTextField outputField = new JTextField(30);
    private JRadioButton radioMediane;
    private JRadioButton formatJpeg;
    private JCheckBox gauss;
    private JRadioButton lupton;
    private JRadioButton classic;
    JProgressBar progressBar = new JProgressBar(0, 100);
    private JComboBox[] ch;
    private JButton preview;
    private JButton start;
    private JButton abort;
    private JButton pause;
    private JButton help = new JButton();
    private final Aladin aladin;
    private MainPanel mainPanel;
    private ContextGui context;
    private String titlehelp;
    private JButton reset;
    private JText[] cutMin = new JText[3];
    private JText[] cutMiddle = new JText[3];
    private JText[] cutMax = new JText[3];
    private JText[] function = new JText[3];
    private JText[] luptonM = new JText[3];
    private JText[] luptonS = new JText[3];
    private JText luptonQ;
    private ArrayList<JText> arrayJText = new ArrayList();
    private PlanBGRgb planPreview = null;
    private Compa compa = new Compa();
    private JLabel tileStat;
    private JLabel timeStat;

    public TabRgb(Aladin aladin, MainPanel mainPanel) {
        super(new BorderLayout());
        this.aladin = aladin;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        this.createChaine(Aladin.getChaine());
        this.help = Util.getHelpButton(this, this.HELP);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 2, 2, 2);
        JPanel pCenter = new JPanel();
        GridBagLayout g = new GridBagLayout();
        pCenter.setLayout(g);
        pCenter.setBorder(BorderFactory.createEmptyBorder(5, 55, 5, 55));
        JLabel info = new JLabel(Util.fold(this.RGBALLSKY, 80, true));
        info.setFont(info.getFont().deriveFont(2));
        c.gridwidth = 0;
        c.insets.bottom = 20;
        pCenter.add((Component)info, c);
        c.insets.bottom = 2;
        int n = 3;
        this.ch = new JComboBox[n];
        for (int i = 0; i < n; ++i) {
            this.ch[i] = new JComboBox();
            this.ch[i].addActionListener(this);
            this.ch[i].setPreferredSize(new Dimension(200, 20));
            JLabel ll = new JLabel(this.getLabelSelector(i));
            ll.setForeground(this.getColorLabel(i));
            c.gridwidth = -1;
            c.weightx = 0.0;
            pCenter.add((Component)ll, c);
            c.gridwidth = 0;
            pCenter.add((Component)this.ch[i], c);
            this.ch[i].addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    TabRgb.this.init();
                }
            });
        }
        this.init();
        c.gridwidth = -1;
        c.weightx = 0.0;
        JPanel dirPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.dirLabel = new JLabel(this.REP_DEST);
        pCenter.add((Component)this.dirLabel, c);
        this.browse.setText(this.BROWSE);
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.dirBrowser(TabRgb.this.outputField);
            }
        });
        dirPanel.add(this.outputField);
        this.outputField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TabRgb.this.resumeWidgets();
            }
        });
        if (Aladin.aladin.configuration.isLookAndFeelJava()) {
            dirPanel.add(this.browse);
        }
        c.gridwidth = 0;
        pCenter.add((Component)dirPanel, c);
        c.gridwidth = 0;
        c.fill = 2;
        int m = c.insets.top;
        pCenter.add((Component)this.getParamPanel(), c);
        c.insets.top = m;
        this.progressBar.setStringPainted(true);
        JPanel pProgress = new JPanel(new BorderLayout());
        pProgress.setBorder(new EmptyBorder(50, 0, 15, 0));
        pProgress.add((Component)this.progressBar, "Center");
        pProgress.add((Component)this.createStatPanel(), "South");
        pCenter.add((Component)pProgress, c);
        JPanel fin = new JPanel(new BorderLayout());
        JPanel pBtn = new JPanel();
        pBtn.setLayout(new BoxLayout(pBtn, 0));
        pBtn.add(Box.createHorizontalGlue());
        this.preview = new JButton(this.getString("SEEPREVIEW"));
        this.preview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.createPreview();
            }
        });
        pBtn.add(this.preview);
        JButton b = new JButton(this.getString("CMDLINE"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.seeCmd();
            }
        });
        pBtn.add(b);
        pBtn.add(new JLabel(" - "));
        this.start = new JButton(this.getString("START"));
        this.start.addActionListener(this);
        pBtn.add(this.start);
        this.pause = new JButton(this.getString("PAUSE"));
        this.pause.addActionListener(this);
        pBtn.add(this.pause);
        this.abort = new JButton(this.getString("ABORT"));
        this.abort.addActionListener(this);
        pBtn.add(this.abort);
        pBtn.add(Box.createRigidArea(new Dimension(10, 0)));
        pBtn.add(Box.createHorizontalGlue());
        fin.add((Component)pBtn, "Center");
        fin.add((Component)this.help, "East");
        this.add((Component)pCenter, "Center");
        this.add((Component)fin, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    private void seeCmd() {
        String s = this.getCmdLine();
        this.aladin.copyToClipBoard(s);
        this.aladin.console.printInPad(s + "\n");
        this.aladin.console.show();
        Aladin.info(this, this.getString("CMDLINEINFO") + "\n=> " + s);
    }

    private JPanel getParamPanel() {
        JRadioButton b;
        TabRgb f = this;
        GridBagLayout g = new GridBagLayout();
        JPanel p = new JPanel(g);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        final JTabbedPane pTab = new JTabbedPane();
        ButtonGroup bg = new ButtonGroup();
        JPanel p1 = new JPanel();
        this.classic = b = new JRadioButton("Classic");
        bg.add(b);
        p1.add(b);
        b.setSelected(true);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pTab.setSelectedIndex(0);
                TabRgb.this.updatePreview();
            }
        });
        this.lupton = b = new JRadioButton("Lupton");
        bg.add(b);
        p1.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pTab.setSelectedIndex(1);
                TabRgb.this.updatePreview();
            }
        });
        this.reset = new JButton("reset");
        this.reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TabRgb.this.resetTables();
                    }
                });
            }
        });
        p1.add(this.reset);
        PropPanel.addCouple(f, p, this.getString("RGBMETHOD") + " ", this.getString("RGBMETHODH"), p1, g, c, 13);
        pTab.add("Classic", this.getClassicPanel());
        pTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TabRgb.this.lupton.setSelected(pTab.getSelectedIndex() == 1);
                TabRgb.this.classic.setSelected(pTab.getSelectedIndex() == 0);
                TabRgb.this.updatePreview();
            }
        });
        pTab.add("Lupton", this.getLuptonPanel());
        pTab.setSelectedIndex(0);
        GridBagConstraints c1 = (GridBagConstraints)c.clone();
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 1;
        g.setConstraints(pTab, c);
        p.add(pTab);
        c = c1;
        bg = new ButtonGroup();
        p1 = new JPanel();
        b = new JRadioButton(this.getString("MEDIANJPG") + " ");
        bg.add(b);
        p1.add(b);
        this.radioMediane = b;
        b.setSelected(true);
        b = new JRadioButton(this.getString("AVERAGEJPG"));
        bg.add(b);
        p1.add(b);
        PropPanel.addCouple(f, p, this.getString("METHODJPG"), this.getString("METHODJPGH"), p1, g, c, 13);
        bg = new ButtonGroup();
        p1 = new JPanel();
        b = new JRadioButton("JPEG");
        bg.add(b);
        p1.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.updatePreview();
            }
        });
        this.formatJpeg = b;
        b = new JRadioButton("PNG");
        bg.add(b);
        p1.add(b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabRgb.this.updatePreview();
            }
        });
        b.setSelected(true);
        PropPanel.addCouple(f, p, this.getString("FORMATTILES") + " ", this.getString("FORMATTILESH"), p1, g, c, 13);
        return p;
    }

    private JPanel getClassicPanel() {
        for (int c = 0; c < RGB.length; ++c) {
            JText t;
            this.cutMin[c] = t = new JText();
            this.arrayJText.add(t);
            this.cutMiddle[c] = t = new JText();
            this.arrayJText.add(t);
            this.cutMax[c] = t = new JText();
            this.arrayJText.add(t);
            this.function[c] = t = new JText();
            this.arrayJText.add(t);
        }
        JPanel p = new JPanel(new GridLayout(RGB.length + 1, 5));
        p.add(new JLabel(""));
        p.add(new JLab("Cut min", this.cutMin));
        p.add(new JLab("Cut middle", this.cutMiddle));
        p.add(new JLab("Cut max", this.cutMax));
        p.add(new JLabel("Function", 0));
        for (int c = 0; c < RGB.length; ++c) {
            p.add(new JLabel(RGB[c], 0));
            p.add(this.cutMin[c]);
            p.add(this.cutMiddle[c]);
            p.add(this.cutMax[c]);
            p.add(this.function[c]);
        }
        return p;
    }

    private JPanel getLuptonPanel() {
        JText t;
        JPanel p1 = new JPanel(new BorderLayout());
        JPanel p = new JPanel(new GridLayout(RGB.length + 1, 3));
        p.add(new JLabel(""));
        p.add(new JLab("Minimum", this.luptonM));
        p.add(new JLab("Stretch", this.luptonS));
        for (int c = 0; c < RGB.length; ++c) {
            p.add(new JLabel(RGB[c], 0));
            this.luptonM[c] = t = new JText();
            p.add(t);
            this.arrayJText.add(t);
            this.luptonS[c] = t = new JText();
            p.add(t);
            this.arrayJText.add(t);
        }
        p1.add((Component)p, "Center");
        p = new JPanel(new GridLayout(2, 1));
        p.add(new JLabel("Q", 0));
        this.luptonQ = t = new JText();
        p.add(t);
        this.arrayJText.add(t);
        p1.add((Component)p, "East");
        return p1;
    }

    private void updatePreview() {
        if (this.planPreview == null) {
            return;
        }
        this.planPreview.updatePreview();
    }

    private void createPreview() {
        this.aladin.view.autoViewGenerator();
        final TabRgb ici = this;
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Util.pause(500);
                    TabRgb.this.planPreview = ((TabRgb)TabRgb.this).aladin.calque.createPlanBGRgb(ici, TabRgb.this.getSelectedPlan(0), TabRgb.this.getSelectedPlan(1), TabRgb.this.getSelectedPlan(2));
                    ((TabRgb)TabRgb.this).aladin.view.autoViewGenerator();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMissing() {
        for (int c = 0; c < 3; ++c) {
            PlanBG p = this.getSelectedPlan(c);
            if (p != null) continue;
            return c;
        }
        return -1;
    }

    protected PlanBG getSelectedPlan(int c) {
        Object o = this.ch[c].getSelectedItem();
        return o instanceof String ? null : (PlanBG)this.ch[c].getSelectedItem();
    }

    public PlanBG[] getSelectedPlans() {
        return new PlanBG[]{this.getSelectedPlan(0), this.getSelectedPlan(1), this.getSelectedPlan(2)};
    }

    public int getRGBMethod() {
        return this.classic.isSelected() ? 0 : 1;
    }

    public ModeTree getModeTree() {
        if (this.radioMediane.isSelected()) {
            return ModeTree.treeMedian;
        }
        return ModeTree.treeMean;
    }

    public int getFormat() {
        if (this.formatJpeg.isSelected()) {
            return 1;
        }
        return 0;
    }

    public double getPixelMin(int c) {
        return Double.parseDouble(this.cutMin[c].getText());
    }

    public double getPixelMiddle(int c) {
        return Double.parseDouble(this.cutMiddle[c].getText());
    }

    public double getPixelMax(int c) {
        return Double.parseDouble(this.cutMax[c].getText());
    }

    public double getCutMin(int c) {
        return this.noScaleAndZero(c, Double.parseDouble(this.cutMin[c].getText()));
    }

    public double getCutMiddle(int c) {
        return this.noScaleAndZero(c, Double.parseDouble(this.cutMiddle[c].getText()));
    }

    public double getCutMax(int c) {
        return this.noScaleAndZero(c, Double.parseDouble(this.cutMax[c].getText()));
    }

    public String getTransfertFct(int c) {
        return this.function[c].getText();
    }

    public double getLuptonM(int c) {
        return this.getLuptonVal(this.luptonM[c]);
    }

    public double getLuptonS(int c) {
        return this.getLuptonVal(this.luptonS[c]);
    }

    public double getLuptonQ() {
        return this.getLuptonVal(this.luptonQ);
    }

    private double getLuptonVal(JText t) {
        try {
            return Double.parseDouble(t.getText());
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private double noScaleAndZero(int c, double val) {
        PlanBG p = this.getSelectedPlan(c);
        return (val - p.bZero) / p.bScale;
    }

    public void resetTables() {
        for (JText t : this.arrayJText) {
            t.setManual(false);
        }
        this.updateTables();
        this.updatePreview();
    }

    public boolean hasManual() {
        for (JText t : this.arrayJText) {
            if (!t.manual) continue;
            return true;
        }
        return false;
    }

    public void updateTables() {
        this.initTab(false);
    }

    private void initTab() {
        this.initTab(true);
    }

    public void initTab(boolean alsoQ) {
        if (this.cutMin[0] == null) {
            return;
        }
        for (int c = 0; c < 3; ++c) {
            PlanBG p = this.getSelectedPlan(c);
            this.cutMin[c].setText(p == null ? "--" : Util.myRound(p.getPixelCtrlMin()));
            this.cutMiddle[c].setText(p == null ? "--" : Util.myRound(p.getPixelCtrlMiddle()));
            this.cutMax[c].setText(p == null ? "--" : Util.myRound(p.getPixelCtrlMax()));
            this.function[c].setText(p == null ? "--" : p.getTransfertFctInfo());
            this.luptonM[c].setText(p == null ? "--" : Util.myRound(BuilderRgb.estimateLuptonM(p)));
            this.luptonS[c].setText(p == null ? "--" : Util.myRound(BuilderRgb.estimateLuptonS(p)));
        }
        if (alsoQ) {
            this.luptonQ.setText("20");
        }
    }

    protected String getLabelSelector(int i) {
        return i == 0 ? R : (i == 1 ? G : (i == 2 ? B : ""));
    }

    protected Color getColorLabel(int i) {
        return i == 0 ? Color.red : (i == 1 ? Color.green : (i == 2 ? Color.blue : Color.black));
    }

    private void createChaine(Chaine chaine) {
        this.BROWSE = this.getString("FILEBROWSE");
        this.REP_DEST = this.getString("REPDALLSKY");
        this.RGBALLSKY = this.getString("RGBALLSKY");
        this.HELP = this.getString("HELPRGBALLSKY");
        this.titlehelp = this.getString("HHELP");
        R = this.getString("RGBRED");
        G = this.getString("RGBGREEN");
        B = this.getString("RGBBLUE");
    }

    private String getString(String k) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(k);
    }

    protected PlanBG[] getPlan() {
        try {
            Vector<Plan> v = this.aladin.calque.getPlanBG();
            if (v == null) {
                return new PlanBG[0];
            }
            Object[] x = v.toArray();
            int n = x.length;
            for (Object p : x) {
                if (((PlanBG)p).isColored()) {
                    --n;
                    continue;
                }
                if (!((PlanBG)p).canbeTruePixels()) {
                    --n;
                    continue;
                }
                if (Aladin.BETA || ((PlanBG)p).isLocalAllSky()) continue;
                --n;
            }
            PlanBG[] pi = new PlanBG[n];
            int i = 0;
            for (Object p : x) {
                if (((PlanBG)p).isColored() || !((PlanBG)p).canbeTruePixels() || !Aladin.BETA && !((PlanBG)p).isLocalAllSky()) continue;
                pi[i++] = (PlanBG)p;
            }
            Arrays.sort(pi, this.compa);
            return pi;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new PlanBG[0];
        }
    }

    private JPanel createStatPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 10, 2, 2);
        JPanel p = new JPanel(g);
        this.tileStat = new JLabel("--");
        PropPanel.addCouple(p, ".RGB tiles: ", this.tileStat, g, c);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(p, ".Time: ", this.timeStat, g, c);
        return p;
    }

    protected void setStat(String sTile, String sTime) {
        this.tileStat.setText(sTile);
        this.timeStat.setText(sTime);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            this.start();
        } else if (e.getSource() == this.abort) {
            this.abort();
        } else if (e.getSource() == this.pause) {
            this.pause();
        }
        this.resumeWidgets();
    }

    private String getCmdLine() {
        boolean flagLupton;
        int missing = this.getMissing();
        StringBuilder cmd = new StringBuilder();
        for (int c = 0; c < 3; ++c) {
            if (c == missing) continue;
            PlanBG p = this.getSelectedPlan(c);
            cmd.append(" in" + RGB[c] + "=\"" + p.getUrl() + "\"");
        }
        cmd.append(" " + (Object)((Object)Param.color) + (this.getFormat() == 0 ? "=png" : "=jpg"));
        boolean bl = flagLupton = this.getRGBMethod() == 1;
        if (flagLupton) {
            StringBuilder m = new StringBuilder();
            StringBuilder s = new StringBuilder();
            double mx = 0.0;
            double om = Double.NaN;
            double sx = 0.0;
            double os = Double.NaN;
            boolean sameM = true;
            boolean sameS = true;
            for (int c = 0; c < 3; ++c) {
                if (m.length() > 0) {
                    m.append('/');
                }
                mx = this.getLuptonM(c);
                m.append(mx);
                if (s.length() > 0) {
                    s.append('/');
                }
                sx = this.getLuptonS(c);
                s.append(sx);
                if (!Double.isNaN(om) && mx != om) {
                    sameM = false;
                }
                om = mx;
                if (!Double.isNaN(os) && sx != os) {
                    sameS = false;
                }
                os = sx;
            }
            cmd.append(" " + (Object)((Object)Param.luptonM) + "=" + (sameM ? mx + "" : m));
            cmd.append(" " + (Object)((Object)Param.luptonS) + "=" + (sameS ? sx + "" : s));
            cmd.append(" " + (Object)((Object)Param.luptonQ) + "=" + this.getLuptonQ());
        } else {
            for (int c = 0; c < 3; ++c) {
                if (c == missing) continue;
                PlanBG p = this.getSelectedPlan(c);
                this.context.setRgbInput(p.getUrl(), c);
                String s = this.getPixelMin(c) + " " + this.getPixelMiddle(c) + " " + this.getPixelMax(c);
                String f = this.getTransfertFct(c);
                if (!f.equalsIgnoreCase("linear")) {
                    s = s + " " + f;
                }
                cmd.append(" cm" + RGB[c] + "=\"" + s + "\"");
            }
        }
        cmd.append(" " + (Object)((Object)Param.id) + "=TEST/P/hipsrgb out=\"" + this.outputField.getText() + "\" RGB");
        return cmd.toString();
    }

    private void start() {
        block14: {
            if (!this.hasPlanSelection()) {
                Aladin.error("Select two or three original HiPS");
                return;
            }
            String out = this.outputField.getText();
            if ("".equals(out) || !new File(out).getParentFile().isDirectory()) {
                Aladin.error("Choose an output directory");
                return;
            }
            File fout = new File(out);
            if (!fout.exists()) {
                fout.mkdir();
            }
            if (!fout.isDirectory() || !fout.canWrite()) {
                Aladin.error("Cannot create or write in the output directory");
                return;
            }
            try {
                boolean flagLupton = this.getRGBMethod() == 1;
                int missing = this.getMissing();
                if (flagLupton) {
                    StringBuilder m = new StringBuilder();
                    StringBuilder s = new StringBuilder();
                    for (int c = 0; c < 3; ++c) {
                        PlanBG p = this.getSelectedPlan(c);
                        if (p != null) {
                            this.context.setRgbInput(p.getUrl(), c);
                        }
                        if (m.length() > 0) {
                            m.append('/');
                        }
                        m.append(this.getLuptonM(c));
                        if (s.length() > 0) {
                            s.append('/');
                        }
                        s.append(this.getLuptonS(c));
                    }
                    this.context.setRgbLuptonM(m.toString());
                    this.context.setRgbLuptonS(s.toString());
                    this.context.setRgbLuptonQ(this.getLuptonQ() + "");
                } else {
                    for (int c = 0; c < 3; ++c) {
                        if (c == missing) continue;
                        PlanBG p = this.getSelectedPlan(c);
                        this.context.setRgbInput(p.getUrl(), c);
                        String s = this.getPixelMin(c) + " " + this.getPixelMiddle(c) + " " + this.getPixelMax(c);
                        String f = this.getTransfertFct(c);
                        if (!f.equalsIgnoreCase("linear")) {
                            s = s + " " + f;
                        }
                        this.context.setRgbCmParam(s, c);
                    }
                }
                this.context.setRgbOutput(this.outputField.getText());
                this.context.setHierarchyAlgo(this.getModeTree());
                this.context.setRgbFormat(this.getFormat());
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.context.setProgressBar(this.progressBar);
                new Task((Context)this.context, Action.RGB, true);
            }
            catch (Exception e1) {
                Aladin.error(this, "RGB HiPS creation error");
                if (Aladin.levelTrace < 3) break block14;
                e1.printStackTrace();
            }
        }
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the HiPS RGB creation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void dirBrowser(JTextField dir) {
        String currentDirectoryPath = dir.getText().trim();
        String path = Util.dirBrowser("", currentDirectoryPath, dir, 0);
        if (path == null) {
            return;
        }
        this.actionPerformed(new ActionEvent(dir, -1, "dirBrowser Action"));
    }

    protected void init() {
        Object[] save = new Object[]{this.ch[0].getSelectedItem(), this.ch[1].getSelectedItem(), this.ch[2].getSelectedItem()};
        PlanBG[] plans = this.getPlan();
        for (int i = 0; i < 3; ++i) {
            this.ch[i].removeAllItems();
            this.ch[i].addItem(this.CHOOSE);
        }
        for (PlanBG planBG : plans) {
            for (int i = 0; i < 3; ++i) {
                this.ch[i].addItem(planBG);
                if (save[i] == null || planBG != save[i]) continue;
                this.ch[i].setSelectedItem(planBG);
            }
        }
        if (this.ch[0].getSelectedIndex() == 0 && this.ch[1].getSelectedIndex() == 0 && this.ch[2].getSelectedIndex() == 0) {
            int n = this.ch[0].getItemCount();
            if (n == 3) {
                this.ch[0].setSelectedIndex(1);
                this.ch[2].setSelectedIndex(2);
            } else {
                for (int i = 0; i < 3 && i < n - 1; ++i) {
                    this.ch[i].setSelectedIndex(i + 1);
                }
            }
        }
        this.initTab();
    }

    @Override
    public void show() {
        super.show();
        this.init();
    }

    public void help() {
        JOptionPane.showMessageDialog(this, this.HELP, this.titlehelp, 1);
    }

    private boolean hasPlanSelection() {
        int nb = 0;
        for (int i = 0; i < this.ch.length; ++i) {
            Object o = this.ch[i].getSelectedItem();
            if (!(o instanceof PlanBG)) continue;
            ++nb;
        }
        return nb > 1;
    }

    protected void resumeWidgets() {
        try {
            boolean readyToDo = this.hasPlanSelection() && this.outputField.getText().trim().length() > 0;
            boolean isRunning = this.context.isTaskRunning();
            this.start.setEnabled(readyToDo && !isRunning);
            this.pause.setEnabled(isRunning);
            this.abort.setEnabled(isRunning);
            this.preview.setEnabled(!isRunning);
            this.reset.setEnabled(this.hasPlanSelection());
            this.updateTables();
            this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class JText
    extends JTextField {
        boolean manual;

        public JText() {
            super(TEXTSIZE);
            this.setHorizontalAlignment(0);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    JText.this.setManual(JText.this.getText().trim().length() > 0);
                    JText.this.afterUpdate();
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
        }

        void setManual(boolean manual) {
            this.manual = manual;
            this.setFont(this.getFont().deriveFont(manual ? 1 : 0));
            this.setForeground(manual ? Color.red : Color.black);
        }

        void afterUpdate() {
            if (this.manual) {
                TabRgb.this.updatePreview();
            } else {
                TabRgb.this.updateTables();
            }
            TabRgb.this.reset.setEnabled(this.manual || TabRgb.this.hasManual());
        }

        @Override
        public void setText(String s) {
            if (this.manual) {
                return;
            }
            super.setText(s);
        }

        void moins() {
            this.incr(-1);
        }

        void plus() {
            this.incr(1);
        }

        void incr(int sens) {
            try {
                double x = Double.parseDouble(this.getText());
                double incr = x / 10.0;
                super.setText(Util.myRound(x += incr * (double)sens));
                this.setManual(true);
                this.afterUpdate();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public String toString() {
            return this.getText() + (this.manual ? "/manual" : "");
        }
    }

    class Compa<T>
    implements Comparator<T> {
        Compa() {
        }

        @Override
        public int compare(T o1, T o2) {
            Plan p1 = (Plan)o1;
            Plan p2 = (Plan)o2;
            return p1.getEnergy() == p2.getEnergy() ? 0 : (p1.getEnergy() < p2.getEnergy() ? 1 : -1);
        }
    }

    class JLab
    extends JPanel {
        JLabel label;
        final JText[] v;

        public JLab(String text, JText[] v) {
            this.v = v;
            JButton b = new JButton(" - ");
            b.setBorder(null);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLab.this.moins();
                }
            });
            this.add(b);
            this.label = new JLabel(text);
            this.add(this.label);
            b = new JButton(" + ");
            b.setBorder(null);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JLab.this.plus();
                }
            });
            this.add(b);
        }

        void moins() {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i].moins();
            }
        }

        void plus() {
            for (int i = 0; i < this.v.length; ++i) {
                this.v[i].plus();
            }
        }
    }
}

